#ifndef SST_EXT_ATP_SPECIALDATA_H
#define SST_EXT_ATP_SPECIALDATA_H


#include "SST_Ext_DEFINES.h"
#include "sst_types.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 05 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_SpecialData.h#1:incl:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
/*Data operations test struct*/
typedef struct EXT_ATP_SpecialDataOpAESTestDataStruct{  
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_AESKey[TST_AES_KEY_SIZE];
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxByte_t                    TST_AuthenticatorAESKey[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyType1;
    DxByte_t                    TST_AESKey2[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyType2;
    DxByte_t                    TST_AESKeyTemp[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyTypeTemp;
    DxUint32_t                  TST_KeySizeInBytes;
    CRYS_AES_IvCounter_t        TST_IVCounter;       
    CRYS_AES_OperationMode_t    TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    DxUint8_t                   TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t                   TST_DataOutDecrypt[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} EXT_ATP_SpecialDataOpAESTestDataStruct;

typedef struct EXT_ATP_SpecialDataOpDESTestDataStruct{  
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_DESKey1[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyType1;
    DxByte_t                    TST_DESKey2[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyType2;
    DxByte_t                    TST_DESKeyTemp[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyTypeTemp;
    DxUint32_t                  TST_KeySizeInBytes;
    CRYS_DES_Iv_t               TST_IVCounter;       
    CRYS_DES_OperationMode_t    TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    DxUint8_t                   TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t                   TST_DataOutDecrypt[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} EXT_ATP_SpecialDataOpDESTestDataStruct;

typedef struct EXT_ATP_SpecialDataOpHMACTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_HMACKey1[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKey1Size;
    DxByte_t                    TST_HMACKey2[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKey2Size;
    DxByte_t                    TST_HMACKeyTemp[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKeyTempSize;  
    CRYS_HASH_OperationMode_t   TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    CRYS_HASH_Result_t          TST_DataHMAC_Result1;
    CRYS_HASH_Result_t          TST_DataHMAC_Result2;
    DxUint32_t                  TST_HASHSize;
} EXT_ATP_SpecialDataOpHMACTestDataStruct;

typedef struct EXT_ATP_SpecialDataOpRSATestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    /*Challenge key*/
    DxUint32_t                  TST_ChalengeKeySizeInBytes;
    DxByte_t                    TST_N[TST_N_SIZE_BYTES];
    DxByte_t                    TST_D[TST_N_SIZE_BYTES];
    DxByte_t                    TST_E[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_ChalengeKeyESizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize; 
    /*Key Creation parameters for Keys 1 and 2 */
    DxUint32_t                  TST_Key1SizeInBytes;
    DxByte_t                    TST_E1[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E1SizeInBytes;
    /* Key info buffers for keys 3 and 4 */
    DxByte_t                    TST_N3[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_N3SizeInBytes;
    DxByte_t                    TST_D3[TST_D_SIZE_BYTES];
    DxUint32_t                  TST_D3SizeInBytes;
    DxByte_t                    TST_E3[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E3SizeInBytes;
    DxByte_t                    TST_N4[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_N4SizeInBytes;
    DxByte_t                    TST_D4[TST_D_SIZE_BYTES]; 
    DxUint32_t                  TST_D4SizeInBytes;
    DxByte_t                    TST_E4[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E4SizeInBytes;
    DxByte_t                    TST_P4[TST_P_SIZE_BYTES];
    DxUint32_t                  TST_P4SizeInBytes;
    DxByte_t                    TST_Q4[TST_Q_SIZE_BYTES];
    DxUint32_t                  TST_Q4SizeInBytes;
    DxByte_t                    TST_DP4[TST_DP_SIZE_BYTES];
    DxUint32_t                  TST_DP4SizeInBytes;
    DxByte_t                    TST_DQ4[TST_DQ_SIZE_BYTES];
    DxUint32_t                  TST_DQ4SizeInBytes;
    DxByte_t                    TST_Qinv4[TST_QINV_SIZE_BYTES];
    DxUint32_t                  TST_Qinv4SizeInBytes;
    /* Key info buffers for keys 5 and 6 */
    DxByte_t                    TST_N5[TST_N_SIZE_BYTES];
    DxByte_t                    TST_D5[TST_D_SIZE_BYTES];
    DxByte_t                    TST_E5[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E5SizeInBytes;
    DxUint32_t                  TST_Key5SizeInBytes;
    DxByte_t                    TST_P5[TST_P_SIZE_BYTES];
    DxByte_t                    TST_Q5[TST_Q_SIZE_BYTES];
    DxByte_t                    TST_DP5[TST_DP_SIZE_BYTES];
    DxByte_t                    TST_DQ5[TST_DQ_SIZE_BYTES];
    DxByte_t                    TST_Qinv5[TST_QINV_SIZE_BYTES];
    /*Data*/ 
    DxByte_t                    TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize; 
    DxByte_t                    TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint16_t                  TST_DataOutSize;
    CRYS_RSA_HASH_OpMode_t    TST_HASHOperationMode;
    DxUint16_t                  TST_SaltLengthSign;
    DxUint16_t                  TST_SaltLengthVerify;
} EXT_ATP_SpecialDataOpRSATestDataStruct;


/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpAES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/
  DxError_t SST_Ext_ATP_SpecialDataOpAES( void );
  
  /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpDES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a DES symmetric key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 DxError_t SST_Ext_ATP_SpecialDataOpDES(void);
 
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpHMAC        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *  Test the insertion, generation, reading, deletion, and usage of a HMAC key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
  DxError_t SST_Ext_ATP_SpecialDataOpHMAC(void);
  
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpRSA        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *  Test the insertion, generation, reading, deletion, and usage of a RSA key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 DxError_t SST_Ext_ATP_SpecialDataOpRSA(void);
  
  
#ifdef __cplusplus
}
#endif

#endif

